<?php
// Enable error reporting for debugging
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include('connection.php');
session_start();

// List of Tanzanian subjects with their table names
$subjects = [
    'Mathematics' => 'mathematics',
    'English' => 'english',
    'Kiswahili' => 'kiswahili',
    'Physics' => 'physics',
    'Chemistry' => 'chemistry',
    'Biology' => 'biology',
    'Geography' => 'geography',
    'History' => 'history',
    'Civics' => 'civics'
];

// Initialize variables
$filter_query = '';
$filter_params = [];
$subject_table = '';
$results = [];

// Retrieve filter values from form submission
$year = isset($_GET['year']) ? $_GET['year'] : '';
$class = isset($_GET['class']) ? $_GET['class'] : '';
$subject = isset($_GET['subject']) ? $_GET['subject'] : '';
$exam_type = isset($_GET['exam_type']) ? $_GET['exam_type'] : '';

// Build the filter query
if ($year) {
    $filter_query .= " AND year = ?";
    $filter_params[] = $year;
}

if ($class) {
    $filter_query .= " AND class = ?";
    $filter_params[] = $class;
}

if ($subject && array_key_exists($subject, $subjects)) {
    $subject_table = $subjects[$subject]; // Correctly fetch the table name for the subject
}

if ($exam_type) {
    $filter_query .= " AND exam_type = ?";
    $filter_params[] = $exam_type;
}

// Check if a valid subject table is selected
if ($subject_table) {
    // Prepare the SQL query to get results from the selected subject table
    $sql = "SELECT registration_number, class, year, subject, score, exam_type, uploaded_by 
            FROM $subject_table WHERE 1=1 $filter_query";
    $stmt = $con->prepare($sql);
    if (!empty($filter_params)) {
        $stmt->bind_param(str_repeat('s', count($filter_params)), ...$filter_params);
    }
    $stmt->execute();
    $result = $stmt->get_result();

    // Fetch results
    while ($row = $result->fetch_assoc()) {
        $results[] = $row;
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>View Posted Results</title>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

<div class="container mt-5">
    <h2>View Posted School Results</h2>

    <!-- Filter Form -->
    <form method="GET" class="form-inline mb-4">
        <!-- Year Filter -->
        <div class="form-group mx-sm-3 mb-2">
            <label for="year" class="mr-2">Year</label>
            <select name="year" id="year" class="form-control">
                <option value="">All Years</option>
                <?php
                $currentYear = date('Y');
                for ($y = 2010; $y <= $currentYear; $y++) {
                    $selected = ($year == $y) ? 'selected' : '';
                    echo "<option value='$y' $selected>$y</option>";
                }
                ?>
            </select>
        </div>

        <!-- Class Filter -->
        <div class="form-group mx-sm-3 mb-2">
            <label for="class" class="mr-2">Class</label>
            <select name="class" id="class" class="form-control">
                <option value="">All Classes</option>
                <option value="Form One" <?php echo ($class == 'Form One') ? 'selected' : ''; ?>>Form One</option>
                <option value="Form Two" <?php echo ($class == 'Form Two') ? 'selected' : ''; ?>>Form Two</option>
                <option value="Form Three" <?php echo ($class == 'Form Three') ? 'selected' : ''; ?>>Form Three</option>
                <option value="Form Four" <?php echo ($class == 'Form Four') ? 'selected' : ''; ?>>Form Four</option>
            </select>
        </div>

        <!-- Subject Filter -->
        <div class="form-group mx-sm-3 mb-2">
            <label for="subject" class="mr-2">Subject</label>
            <select name="subject" id="subject" class="form-control">
                <option value="">All Subjects</option>
                <?php
                foreach ($subjects as $subject_name => $subject_table) {
                    $selected = ($subject == $subject_name) ? 'selected' : '';
                    echo "<option value='$subject_name' $selected>$subject_name</option>";
                }
                ?>
            </select>
        </div>

        <!-- Exam Type Filter -->
        <div class="form-group mx-sm-3 mb-2">
            <label for="exam_type" class="mr-2">Exam Type</label>
            <select name="exam_type" id="exam_type" class="form-control">
                <option value="">All Exam Types</option>
                <option value="Midterm 1 Examination" <?php echo ($exam_type == 'Midterm 1 Examination') ? 'selected' : ''; ?>>Midterm 1 Examination</option>
                <option value="Terminal Examination" <?php echo ($exam_type == 'Terminal Examination') ? 'selected' : ''; ?>>Terminal Examination</option>
                <option value="Midterm 2 Examination" <?php echo ($exam_type == 'Midterm 2 Examination') ? 'selected' : ''; ?>>Midterm 2 Examination</option>
                <option value="Annual Examination" <?php echo ($exam_type == 'Annual Examination') ? 'selected' : ''; ?>>Annual Examination</option>
                <option value="Mock Examination" <?php echo ($exam_type == 'Mock Examination') ? 'selected' : ''; ?>>Mock Examination</option>
                <option value="Pre Necta Examination" <?php echo ($exam_type == 'Pre Necta Examination') ? 'selected' : ''; ?>>Pre Necta Examination</option>
                <option value="Pre Necta 2 Examination" <?php echo ($exam_type == 'Pre Necta 2 Examination') ? 'selected' : ''; ?>>Pre Necta 2 Examination</option>
                <option value="Pre Necta 3 Examination" <?php echo ($exam_type == 'Pre Necta 3 Examination') ? 'selected' : ''; ?>>Pre Necta 3 Examination</option>
                <option value="Pre Necta 4 Examination" <?php echo ($exam_type == 'Pre Necta 4 Examination') ? 'selected' : ''; ?>>Pre Necta 4 Examination</option>
            </select>
        </div>

        <!-- Submit Filter Button -->
        <button type="submit" class="btn btn-primary mb-2">Filter Results</button>
    </form>

    <!-- Results Table -->
    <?php if (!empty($results)) { ?>
        <table class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>Registration Number</th>
                    <th>Class</th>
                    <th>Year</th>
                    <th>Subject</th>
                    <th>Score</th>
                    <th>Exam Type</th>
                    <th>Uploaded By</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($results as $row) { ?>
                    <tr>
                        <td><?php echo $row['registration_number']; ?></td>
                        <td><?php echo $row['class']; ?></td>
                        <td><?php echo $row['year']; ?></td>
                        <td><?php echo $row['subject']; ?></td>
                        <td><?php echo $row['score']; ?></td>
                        <td><?php echo $row['exam_type']; ?></td>
                        <td><?php echo $row['uploaded_by']; ?></td>
                    </tr>
                <?php } ?>
            </tbody>
        </table>
    <?php } else { ?>
        <div class="alert alert-info">No results found for the selected filters.</div>
    <?php } ?>
</div>

</body>
</html>
